--[ja] SM5本体のバージョンを以下のグループで分ける
--[[
	previewX	0
	A1,A1a	1
	A2		2
	A3		3
	B1,B1a	10
	B2,B2a	20
	B3		30
	B4,B4a	40
	Other	50
--]] 
function GetSMVersion()
	local v=string.lower(ProductVersion())
	local d=string.lower(VersionDate())
	-- [ja] 最新バージョンを上に書くことでできるだけ処理に負荷をかけないようにする 
	-- 　　旧バージョン？知らない子ですね 
	if string.find(v,"5.0.5",0,true) then
		return 50;
	elseif string.find(v,"5.0.",0,true) then
		return 60;
	elseif string.find(v,"5.",0,true) then
		return 100;
	elseif string.find(v,"v5.0 beta 4",0,true) then
		return 40;
	elseif string.find(v,"v5.0 beta 3",0,true) then
		return 30;
	elseif string.find(v,"v5.0 beta 2",0,true) then
		return 20;
	elseif string.find(v,"v5.0 beta 1",0,true) then
		return 10;
	elseif string.find(v,"v5.0 beta",0,true) then
		return 50;
	elseif string.find(v,"v5.0 alpha 1",0,true) then
		return 1;
	elseif string.find(v,"v5.0 alpha 2",0,true) then
		return 2;
	elseif string.find(v,"v5.0 alpha 3",0,true) then
		return 3;
	elseif string.find(v,"v5.0 preview",0,true) then
		return 0;
	end;
	return 100;
end;

